<?php
/* --------------------------------------------------------------
  OnGetProductEanEventListener.php 2020-02-20
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Product\Ean\Listener;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductEanEventInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitEanEvent;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Ean;

/**
 * Class OnGetProductEanEventListener
 * @package Gambio\Shop\Product\Ean\Listener
 */
class OnGetProductEanEventListener
{
    /**
     * @param OnGetProductEanEventInterface $event
     */
    public function __invoke(OnGetProductEanEventInterface $event)
    {
        $productEan          = new Ean($event->product()->getEan());
        $sellingUnitEanEvent = new OnGetSellingUnitEanEvent(
            $event->product(),
            $event->productId(),
            $event->modifierIdentifiers(),
            $event->languageId(),
            $productEan
        );
        $event->dispatcher()->dispatch($sellingUnitEanEvent);
        $event->setEan($sellingUnitEanEvent->ean());
    }
    
}